<?php

	return [
		'currency_code' => 'USD',
		'currency_symbol' => '$',
		'vat'	=> 0,
		'pay_what_you_want' => [
			'enabled' => 0,
			'for' => 'products,subscriptions'
		],
		'exchange_rate' => 1,
		'currencies' => [
			'AUD' => [ 'code' => 'AUD', 'symbol' => 'AU$', 'name' => 'Australian Dollar', 'decimals' => 2, 'exchange_rate' => null], 
			'BGN' => [ 'code' => 'BGN', 'symbol' => 'BGN', 'name' => 'Bulgarian Lev', 'decimals' => 2, 'exchange_rate' => null], 
			'BRL' => [ 'code' => 'BRL', 'symbol' => 'R$', 'name' => 'Brazilian Real', 'decimals' => 2, 'exchange_rate' => null], 
			'CAD' => [ 'code' => 'CAD', 'symbol' => 'CA$', 'name' => 'Canadian Dollar', 'decimals' => 2, 'exchange_rate' => null], 
			'CHF' => [ 'code' => 'CHF', 'symbol' => 'CHF', 'name' => 'Swiss Franc', 'decimals' => 2, 'exchange_rate' => null], 
			'CNY' => [ 'code' => 'CNY', 'symbol' => 'CN¥', 'name' => 'Chinese Yuan', 'decimals' => 2, 'exchange_rate' => null], 
			'CZK' => [ 'code' => 'CZK', 'symbol' => 'Kč', 'name' => 'Czech Republic Koruna', 'decimals' => 2, 'exchange_rate' => null], 
			'DKK' => [ 'code' => 'DKK', 'symbol' => 'Dkr', 'name' => 'Danish Krone', 'decimals' => 2, 'exchange_rate' => null], 
			'EUR' => [ 'code' => 'EUR', 'symbol' => '€', 'name' => 'Euro', 'decimals' => 2, 'exchange_rate' => null], 
			'GBP' => [ 'code' => 'GBP', 'symbol' => '£', 'name' => 'British Pound Sterling', 'decimals' => 2, 'exchange_rate' => null], 
			'HKD' => [ 'code' => 'HKD', 'symbol' => 'HK$', 'name' => 'Hong Kong Dollar', 'decimals' => 2, 'exchange_rate' => null], 
			'HRK' => [ 'code' => 'HRK', 'symbol' => 'kn', 'name' => 'Croatian Kuna', 'decimals' => 2, 'exchange_rate' => null], 
			'HUF' => [ 'code' => 'HUF', 'symbol' => 'Ft', 'name' => 'Hungarian Forint', 'decimals' => 0, 'exchange_rate' => null], 
			'IDR' => [ 'code' => 'IDR', 'symbol' => 'Rp', 'name' => 'Indonesian Rupiah', 'decimals' => 2, 'exchange_rate' => null], 
			'ILS' => [ 'code' => 'ILS', 'symbol' => '₪', 'name' => 'Israeli New Sheqel', 'decimals' => 2, 'exchange_rate' => null], 
			'INR' => [ 'code' => 'INR', 'symbol' => '₹', 'name' => 'Indian Rupee', 'decimals' => 2, 'exchange_rate' => null], 
			'ISK' => [ 'code' => 'ISK', 'symbol' => 'Ikr', 'name' => 'Icelandic Króna', 'decimals' => 0, 'exchange_rate' => null], 
			'JPY' => [ 'code' => 'JPY', 'symbol' => '¥', 'name' => 'Japanese Yen', 'decimals' => 0, 'exchange_rate' => null], 
			'KRW' => [ 'code' => 'KRW', 'symbol' => '₩', 'name' => 'South Korean Won', 'decimals' => 0, 'exchange_rate' => null], 
			'MXN' => [ 'code' => 'MXN', 'symbol' => 'MX$', 'name' => 'Mexican Peso', 'decimals' => 2, 'exchange_rate' => null], 
			'MYR' => [ 'code' => 'MYR', 'symbol' => 'RM', 'name' => 'Malaysian Ringgit', 'decimals' => 2, 'exchange_rate' => null], 
			'NOK' => [ 'code' => 'NOK', 'symbol' => 'Nkr', 'name' => 'Norwegian Krone', 'decimals' => 2, 'exchange_rate' => null], 
			'NZD' => [ 'code' => 'NZD', 'symbol' => 'NZ$', 'name' => 'New Zealand Dollar', 'decimals' => 2, 'exchange_rate' => null], 
			'PHP' => [ 'code' => 'PHP', 'symbol' => '₱', 'name' => 'Philippine Peso', 'decimals' => 2, 'exchange_rate' => null], 
			'PLN' => [ 'code' => 'PLN', 'symbol' => 'zł', 'name' => 'Polish Zloty', 'decimals' => 2, 'exchange_rate' => null], 
			'RON' => [ 'code' => 'RON', 'symbol' => 'RON', 'name' => 'Romanian Leu', 'decimals' => 2, 'exchange_rate' => null], 
			'RUB' => [ 'code' => 'RUB', 'symbol' => 'RUB', 'name' => 'Russian Ruble', 'decimals' => 2, 'exchange_rate' => null], 
			'SEK' => [ 'code' => 'SEK', 'symbol' => 'Skr', 'name' => 'Swedish Krona', 'decimals' => 2, 'exchange_rate' => null], 
			'SGD' => [ 'code' => 'SGD', 'symbol' => 'S$', 'name' => 'Singapore Dollar', 'decimals' => 2, 'exchange_rate' => null], 
			'THB' => [ 'code' => 'THB', 'symbol' => '฿', 'name' => 'Thai Baht', 'decimals' => 2, 'exchange_rate' => null], 
			'TRY' => [ 'code' => 'TRY', 'symbol' => '₺', 'name' => 'Turkish Lira', 'decimals' => 2, 'exchange_rate' => null], 
			'USD' => [ 'code' => 'USD', 'symbol' => '$', 'name' => 'US Dollar', 'decimals' => 2, 'exchange_rate' => null], 
			'ZAR' => [ 'code' => 'ZAR', 'symbol' => 'R', 'name' => 'South African Rand', 'decimals' => 2, 'exchange_rate' => null],
			'AED' => [ 'code' => 'AED', 'symbol' => 'AED', 'name' => 'United Arab Emirates Dirham', 'decimals' => 2, 'exchange_rate' => null],
			'AFN' => [ 'code' => 'AFN', 'symbol' => 'Af', 'name' => 'Afghan Afghani', 'decimals' => 0, 'exchange_rate' => null],
			'ALL' => [ 'code' => 'ALL', 'symbol' => 'ALL', 'name' => 'Albanian Lek', 'decimals' => 0, 'exchange_rate' => null],
			'AMD' => [ 'code' => 'AMD', 'symbol' => 'AMD', 'name' => 'Armenian Dram', 'decimals' => 0, 'exchange_rate' => null],
			'ANG' => [ 'code' => 'ANG', 'symbol' => 'ƒ', 'name' => 'Netherlands Antilles Guilder', 'decimals' => 2, 'exchange_rate' => null],
			'AOA' => [ 'code' => 'AOA', 'symbol' => 'Kz', 'name' => 'Angolan kwanza', 'decimals' => 2, 'exchange_rate' => null],
			'ARS' => [ 'code' => 'ARS', 'symbol' => 'AR$', 'name' => 'Argentine Peso', 'decimals' => 2, 'exchange_rate' => null],
			'AWG' => [ 'code' => 'AWG', 'symbol' => 'ƒ', 'name' => 'Aruban Guilder', 'decimals' => 2, 'exchange_rate' => null],
			'AFL' => [ 'code' => 'AFL', 'symbol' => 'Afl.', 'name' => 'Aruban Florin', 'decimals' => 2, 'exchange_rate' => null],
			'AZN' => [ 'code' => 'AZN', 'symbol' => 'man.', 'name' => 'Azerbaijani Manat', 'decimals' => 2, 'exchange_rate' => null],
			'BAM' => [ 'code' => 'BAM', 'symbol' => 'KM', 'name' => 'Bosnia-Herzegovina Convertible Mark', 'decimals' => 2, 'exchange_rate' => null],
			'BDT' => [ 'code' => 'BDT', 'symbol' => 'Tk', 'name' => 'Bangladeshi Taka', 'decimals' => 2, 'exchange_rate' => null],
			'BBD' => [ 'code' => 'BBD', 'symbol' => 'Bds$', 'name' => 'Barbados dollar', 'decimals' => 2, 'exchange_rate' => null],
			'BHD' => [ 'code' => 'BHD', 'symbol' => 'BD', 'name' => 'Bahraini Dinar', 'decimals' => 3, 'exchange_rate' => null],
			'BIF' => [ 'code' => 'BIF', 'symbol' => 'FBu', 'name' => 'Burundian Franc', 'decimals' => 0, 'exchange_rate' => null],
			'BSD' => [ 'code' => 'BSD', 'symbol' => '$', 'name' => 'Bahamas Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'BMD' => [ 'code' => 'BMD', 'symbol' => '$', 'name' => 'Bermuda Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'BND' => [ 'code' => 'BND', 'symbol' => 'BN$', 'name' => 'Brunei Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'BOB' => [ 'code' => 'BOB', 'symbol' => 'Bs', 'name' => 'Bolivian Boliviano', 'decimals' => 2, 'exchange_rate' => null],
			'BOV' => [ 'code' => 'BOV', 'symbol' => '-', 'name' => 'Bolivian Mvdol', 'decimals' => 2, 'exchange_rate' => null],
			'BTC' => [ 'code' => 'BTC', 'symbol' => '₿', 'name' => 'Bitcoin', 'decimals' => 8, 'exchange_rate' => null],
			'BTN' => [ 'code' => 'BTN', 'symbol' => 'Nu.', 'name' => 'Bhutanese ngultrum', 'decimals' => 2, 'exchange_rate' => null],
			'BWP' => [ 'code' => 'BWP', 'symbol' => 'BWP', 'name' => 'Botswanan Pula', 'decimals' => 2, 'exchange_rate' => null],
			'BYN' => [ 'code' => 'BYN', 'symbol' => 'Br', 'name' => 'Belarusian Ruble', 'decimals' => 0, 'exchange_rate' => null],
			'BZD' => [ 'code' => 'BZD', 'symbol' => 'BZ$', 'name' => 'Belize Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'CDF' => [ 'code' => 'CDF', 'symbol' => 'CDF', 'name' => 'Congolese Franc', 'decimals' => 2, 'exchange_rate' => null],
			'CHE' => [ 'code' => 'CHE', 'symbol' => '-', 'name' => 'WIR Euro [complementary currency]', 'decimals' => 2, 'exchange_rate' => null],
			'CHW' => [ 'code' => 'CHW', 'symbol' => '-', 'name' => 'WIR Franc [complementary currency]', 'decimals' => 2, 'exchange_rate' => null],
			'CLF' => [ 'code' => 'CLF', 'symbol' => 'UF', 'name' => 'Unidad de Fomento [funds code]', 'decimals' => 4, 'exchange_rate' => null],
			'CLP' => [ 'code' => 'CLP', 'symbol' => 'CL$', 'name' => 'Chilean Peso', 'decimals' => 0, 'exchange_rate' => null],
			'COP' => [ 'code' => 'COP', 'symbol' => 'CO$', 'name' => 'Colombian Peso', 'decimals' => 0, 'exchange_rate' => null],
			'COU' => [ 'code' => 'COU', 'symbol' => '-', 'name' => 'Unidad de Valor Real [UVR] [funds code]', 'decimals' => 2, 'exchange_rate' => null],
			'CRC' => [ 'code' => 'CRC', 'symbol' => '₡', 'name' => 'Costa Rican Colón', 'decimals' => 0, 'exchange_rate' => null],
			'CUC' => [ 'code' => 'CUC', 'symbol' => 'CUC$', 'name' => 'Cuban convertible peso', 'decimals' => 2, 'exchange_rate' => null],
			'CUP' => [ 'code' => 'CUP', 'symbol' => '₱', 'name' => 'Cuba Peso', 'decimals' => 0, 'exchange_rate' => null],
			'CVE' => [ 'code' => 'CVE', 'symbol' => 'CV$', 'name' => 'Cape Verdean Escudo', 'decimals' => 0, 'exchange_rate' => null],
			'DJF' => [ 'code' => 'DJF', 'symbol' => 'Fdj', 'name' => 'Djiboutian Franc', 'decimals' => 0, 'exchange_rate' => null],
			'DOP' => [ 'code' => 'DOP', 'symbol' => 'RD$', 'name' => 'Dominican Peso', 'decimals' => 2, 'exchange_rate' => null],
			'DZD' => [ 'code' => 'DZD', 'symbol' => 'DA', 'name' => 'Algerian Dinar', 'decimals' => 2, 'exchange_rate' => null],
			'EEK' => [ 'code' => 'EEK', 'symbol' => 'Ekr', 'name' => 'Estonian Kroon', 'decimals' => 2, 'exchange_rate' => null],
			'EGP' => [ 'code' => 'EGP', 'symbol' => 'EGP', 'name' => 'Egyptian Pound', 'decimals' => 2, 'exchange_rate' => null],
			'ERN' => [ 'code' => 'ERN', 'symbol' => 'Nfk', 'name' => 'Eritrean Nakfa', 'decimals' => 2, 'exchange_rate' => null],
			'ETB' => [ 'code' => 'ETB', 'symbol' => 'Br', 'name' => 'Ethiopian Birr', 'decimals' => 2, 'exchange_rate' => null],
			'FJD' => [ 'code' => 'FJD', 'symbol' => '$', 'name' => 'Fiji Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'FKP' => [ 'code' => 'FKP', 'symbol' => '£', 'name' => 'Falkland Islands [Malvinas] Pound', 'decimals' => 2, 'exchange_rate' => null],
			'GEL' => [ 'code' => 'GEL', 'symbol' => 'GEL', 'name' => 'Georgian Lari', 'decimals' => 2, 'exchange_rate' => null],
			'GGP' => [ 'code' => 'GGP', 'symbol' => '£', 'name' => 'Guernsey Pound', 'decimals' => 2, 'exchange_rate' => null],
			'GHS' => [ 'code' => 'GHS', 'symbol' => 'GH₵', 'name' => 'Ghanaian Cedi', 'decimals' => 2, 'exchange_rate' => null],
			'GIP' => [ 'code' => 'GIP', 'symbol' => '£', 'name' => 'Gibraltar Pound', 'decimals' => 2, 'exchange_rate' => null],
			'GMD' => [ 'code' => 'GMD', 'symbol' => 'D', 'name' => 'Gambian dalasi', 'decimals' => 2, 'exchange_rate' => null],
			'GNF' => [ 'code' => 'GNF', 'symbol' => 'FG', 'name' => 'Guinean Franc', 'decimals' => 0, 'exchange_rate' => null],
			'GTQ' => [ 'code' => 'GTQ', 'symbol' => 'GTQ', 'name' => 'Guatemalan Quetzal', 'decimals' => 2, 'exchange_rate' => null],
			'GYD' => [ 'code' => 'GYD', 'symbol' => '$', 'name' => 'Guyana Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'HNL' => [ 'code' => 'HNL', 'symbol' => 'HNL', 'name' => 'Honduran Lempira', 'decimals' => 2, 'exchange_rate' => null],
			'HTG' => [ 'code' => 'HTG', 'symbol' => 'G', 'name' => 'Haitian gourde', 'decimals' => 2, 'exchange_rate' => null],
			'IMP' => [ 'code' => 'IMP', 'symbol' => '£', 'name' => 'Isle of Man Pound', 'decimals' => 2, 'exchange_rate' => null],
			'IQD' => [ 'code' => 'IQD', 'symbol' => 'IQD', 'name' => 'Iraqi Dinar', 'decimals' => 3, 'exchange_rate' => null],
			'IRR' => [ 'code' => 'IRR', 'symbol' => 'IRR', 'name' => 'Iranian Rial', 'decimals' => 0, 'exchange_rate' => null],
			'JEP' => [ 'code' => 'JEP', 'symbol' => '£', 'name' => 'Jersey Pound', 'decimals' => 2, 'exchange_rate' => null],
			'JMD' => [ 'code' => 'JMD', 'symbol' => 'J$', 'name' => 'Jamaican Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'JOD' => [ 'code' => 'JOD', 'symbol' => 'JD', 'name' => 'Jordanian Dinar', 'decimals' => 3, 'exchange_rate' => null],
			'KES' => [ 'code' => 'KES', 'symbol' => 'Ksh', 'name' => 'Kenyan Shilling', 'decimals' => 2, 'exchange_rate' => null],
			'KGS' => [ 'code' => 'KGS', 'symbol' => 'лв', 'name' => 'Kyrgyzstan Som', 'decimals' => 2, 'exchange_rate' => null],
			'KHR' => [ 'code' => 'KHR', 'symbol' => 'KHR', 'name' => 'Cambodian Riel', 'decimals' => 2, 'exchange_rate' => null],
			'KMF' => [ 'code' => 'KMF', 'symbol' => 'CF', 'name' => 'Comorian Franc', 'decimals' => 0, 'exchange_rate' => null],
			'KPW' => [ 'code' => 'KPW', 'symbol' => '₩', 'name' => 'North Korean Won', 'decimals' => 0, 'exchange_rate' => null],
			'KWD' => [ 'code' => 'KWD', 'symbol' => 'KD', 'name' => 'Kuwaiti Dinar', 'decimals' => 3, 'exchange_rate' => null],
			'KYD' => [ 'code' => 'KYD', 'symbol' => '$', 'name' => 'Cayman Islands Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'KZT' => [ 'code' => 'KZT', 'symbol' => 'KZT', 'name' => 'Kazakhstani Tenge', 'decimals' => 2, 'exchange_rate' => null],
			'LAK' => [ 'code' => 'LAK', 'symbol' => '₭', 'name' => 'Laos Kip', 'decimals' => 2, 'exchange_rate' => null],
			'LBP' => [ 'code' => 'LBP', 'symbol' => 'LB£', 'name' => 'Lebanese Pound', 'decimals' => 0, 'exchange_rate' => null],
			'LKR' => [ 'code' => 'LKR', 'symbol' => 'SLRs', 'name' => 'Sri Lankan Rupee', 'decimals' => 2, 'exchange_rate' => null],
			'LRD' => [ 'code' => 'LRD', 'symbol' => '$', 'name' => 'Liberia Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'LSL' => [ 'code' => 'LSL', 'symbol' => 'L', 'name' => 'Lesotho loti', 'decimals' => 2, 'exchange_rate' => null],
			'LTL' => [ 'code' => 'LTL', 'symbol' => 'Lt', 'name' => 'Lithuanian Litas', 'decimals' => 2, 'exchange_rate' => null],
			'LVL' => [ 'code' => 'LVL', 'symbol' => 'Ls', 'name' => 'Latvian Lats', 'decimals' => 2, 'exchange_rate' => null],
			'LYD' => [ 'code' => 'LYD', 'symbol' => 'LD', 'name' => 'Libyan Dinar', 'decimals' => 3, 'exchange_rate' => null],
			'MAD' => [ 'code' => 'MAD', 'symbol' => 'MAD', 'name' => 'Moroccan Dirham', 'decimals' => 2, 'exchange_rate' => null],
			'MDL' => [ 'code' => 'MDL', 'symbol' => 'MDL', 'name' => 'Moldovan Leu', 'decimals' => 2, 'exchange_rate' => null],
			'MGA' => [ 'code' => 'MGA', 'symbol' => 'MGA', 'name' => 'Malagasy Ariary', 'decimals' => 0, 'exchange_rate' => null],
			'MKD' => [ 'code' => 'MKD', 'symbol' => 'MKD', 'name' => 'Macedonian Denar', 'decimals' => 2, 'exchange_rate' => null],
			'MMK' => [ 'code' => 'MMK', 'symbol' => 'MMK', 'name' => 'Myanma Kyat', 'decimals' => 0, 'exchange_rate' => null],
			'MNT' => [ 'code' => 'MNT', 'symbol' => '₮', 'name' => 'Mongolia Tughrik', 'decimals' => 2, 'exchange_rate' => null],
			'MOP' => [ 'code' => 'MOP', 'symbol' => 'MOP$', 'name' => 'Macanese Pataca', 'decimals' => 2, 'exchange_rate' => null],
			'MRO' => [ 'code' => 'MRO', 'symbol' => 'UM', 'name' => 'Mauritanian ouguiya', 'decimals' => 1, 'exchange_rate' => null],
			'MUR' => [ 'code' => 'MUR', 'symbol' => 'MURs', 'name' => 'Mauritian Rupee', 'decimals' => 0, 'exchange_rate' => null],
			'MVR' => [ 'code' => 'MVR', 'symbol' => 'MRf', 'name' => 'Maldivian rufiyaa', 'decimals' => 2, 'exchange_rate' => null],
			'MWK' => [ 'code' => 'MWK', 'symbol' => 'MK', 'name' => 'Malawian kwacha', 'decimals' => 2, 'exchange_rate' => null],
			'MXV' => [ 'code' => 'MXV', 'symbol' => '-', 'name' => 'Mexican Unidad de Inversion [UDI] [funds code]', 'decimals' => 2, 'exchange_rate' => null],
			'MZN' => [ 'code' => 'MZN', 'symbol' => 'MTn', 'name' => 'Mozambican Metical', 'decimals' => 2, 'exchange_rate' => null],
			'NAD' => [ 'code' => 'NAD', 'symbol' => 'N$', 'name' => 'Namibian Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'NGN' => [ 'code' => 'NGN', 'symbol' => '₦', 'name' => 'Nigerian Naira', 'decimals' => 2, 'exchange_rate' => null],
			'NIO' => [ 'code' => 'NIO', 'symbol' => 'C$', 'name' => 'Nicaraguan Córdoba', 'decimals' => 2, 'exchange_rate' => null],
			'NPR' => [ 'code' => 'NPR', 'symbol' => 'NPRs', 'name' => 'Nepalese Rupee', 'decimals' => 2, 'exchange_rate' => null],
			'PRB' => [ 'code' => 'PRB', 'symbol' => 'руб', 'name' => 'Transnistrian ruble', 'decimals' => 2, 'exchange_rate' => null],
			'OMR' => [ 'code' => 'OMR', 'symbol' => 'OMR', 'name' => 'Omani Rial', 'decimals' => 3, 'exchange_rate' => null],
			'PAB' => [ 'code' => 'PAB', 'symbol' => 'B/.', 'name' => 'Panamanian Balboa', 'decimals' => 2, 'exchange_rate' => null],
			'PEN' => [ 'code' => 'PEN', 'symbol' => 'S/.', 'name' => 'Peruvian Nuevo Sol', 'decimals' => 2, 'exchange_rate' => null],
			'PGK' => [ 'code' => 'PGK', 'symbol' => 'K', 'name' => 'Papua New Guinean kina', 'decimals' => 2, 'exchange_rate' => null],
			'PKR' => [ 'code' => 'PKR', 'symbol' => 'PKRs', 'name' => 'Pakistani Rupee', 'decimals' => 0, 'exchange_rate' => null],
			'PYG' => [ 'code' => 'PYG', 'symbol' => '₲', 'name' => 'Paraguayan Guarani', 'decimals' => 0, 'exchange_rate' => null],
			'QAR' => [ 'code' => 'QAR', 'symbol' => 'QR', 'name' => 'Qatari Rial', 'decimals' => 2, 'exchange_rate' => null],
			'RSD' => [ 'code' => 'RSD', 'symbol' => 'din.', 'name' => 'Serbian Dinar', 'decimals' => 0, 'exchange_rate' => null],
			'RWF' => [ 'code' => 'RWF', 'symbol' => 'RWF', 'name' => 'Rwandan Franc', 'decimals' => 0, 'exchange_rate' => null],
			'SAR' => [ 'code' => 'SAR', 'symbol' => 'SR', 'name' => 'Saudi Riyal', 'decimals' => 2, 'exchange_rate' => null],
			'SBD' => [ 'code' => 'SBD', 'symbol' => '$', 'name' => 'Solomon Islands Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'SCR' => [ 'code' => 'SCR', 'symbol' => '₨', 'name' => 'Seychelles Rupee', 'decimals' => 2, 'exchange_rate' => null],
			'SDG' => [ 'code' => 'SDG', 'symbol' => 'SDG', 'name' => 'Sudanese Pound', 'decimals' => 2, 'exchange_rate' => null],
			'SHP' => [ 'code' => 'SHP', 'symbol' => '£', 'name' => 'Saint Helena Pound', 'decimals' => 2, 'exchange_rate' => null],
			'SLL' => [ 'code' => 'SLL', 'symbol' => 'Le', 'name' => 'Sierra Leonean leone', 'decimals' => 2, 'exchange_rate' => null],
			'SOS' => [ 'code' => 'SOS', 'symbol' => 'Ssh', 'name' => 'Somali Shilling', 'decimals' => 0, 'exchange_rate' => null],
			'SRD' => [ 'code' => 'SRD', 'symbol' => '$', 'name' => 'Suriname Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'SSP' => [ 'code' => 'SSP', 'symbol' => 'SSP', 'name' => 'South Sudanese pound', 'decimals' => 2, 'exchange_rate' => null],
			'STD' => [ 'code' => 'STD', 'symbol' => 'Db', 'name' => 'São Tomé and Príncipe dobra', 'decimals' => 2, 'exchange_rate' => null],
			'SVC' => [ 'code' => 'SVC', 'symbol' => '$', 'name' => 'El Salvador Colon', 'decimals' => 0, 'exchange_rate' => null],
			'SYP' => [ 'code' => 'SYP', 'symbol' => 'SY£', 'name' => 'Syrian Pound', 'decimals' => 0, 'exchange_rate' => null],
			'SZL' => [ 'code' => 'SZL', 'symbol' => 'L', 'name' => 'Swazi lilangeni', 'decimals' => 2, 'exchange_rate' => null],
			'TJS' => [ 'code' => 'TJS', 'symbol' => '-', 'name' => 'Tajikistani somoni', 'decimals' => 2, 'exchange_rate' => null],
			'TMT' => [ 'code' => 'TMT', 'symbol' => 'T', 'name' => 'Turkmenistan manat', 'decimals' => 2, 'exchange_rate' => null],
			'TND' => [ 'code' => 'TND', 'symbol' => 'DT', 'name' => 'Tunisian Dinar', 'decimals' => 3, 'exchange_rate' => null],
			'TOP' => [ 'code' => 'TOP', 'symbol' => 'T$', 'name' => 'Tongan Paʻanga', 'decimals' => 2, 'exchange_rate' => null],
			'TTD' => [ 'code' => 'TTD', 'symbol' => 'TT$', 'name' => 'Trinidad and Tobago Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'TVD' => [ 'code' => 'TVD', 'symbol' => '$', 'name' => 'Tuvalu Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'TWD' => [ 'code' => 'TWD', 'symbol' => 'NT$', 'name' => 'New Taiwan Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'TZS' => [ 'code' => 'TZS', 'symbol' => 'TSh', 'name' => 'Tanzanian Shilling', 'decimals' => 0, 'exchange_rate' => null],
			'UAH' => [ 'code' => 'UAH', 'symbol' => '₴', 'name' => 'Ukrainian Hryvnia', 'decimals' => 2, 'exchange_rate' => null],
			'UGX' => [ 'code' => 'UGX', 'symbol' => 'USh', 'name' => 'Ugandan Shilling', 'decimals' => 0, 'exchange_rate' => null],
			'USN' => [ 'code' => 'USN', 'symbol' => '$', 'name' => 'United States dollar [next day] [funds code]', 'decimals' => 2, 'exchange_rate' => null],
			'UYI' => [ 'code' => 'UYI', 'symbol' => 'UYI', 'name' => 'Uruguay Peso en Unidades Indexadas [URUIURUI] [funds code]', 'decimals' => 0, 'exchange_rate' => null],
			'UYU' => [ 'code' => 'UYU', 'symbol' => '$U', 'name' => 'Uruguayan Peso', 'decimals' => 2, 'exchange_rate' => null],
			'UZS' => [ 'code' => 'UZS', 'symbol' => 'UZS', 'name' => 'Uzbekistan Som', 'decimals' => 0, 'exchange_rate' => null],
			'VEF' => [ 'code' => 'VEF', 'symbol' => 'Bs.F.', 'name' => 'Venezuelan Bolívar', 'decimals' => 2, 'exchange_rate' => null],
			'VND' => [ 'code' => 'VND', 'symbol' => '₫', 'name' => 'Vietnamese Dong', 'decimals' => 0, 'exchange_rate' => null],
			'VUV' => [ 'code' => 'VUV', 'symbol' => 'VT', 'name' => 'Vanuatu vatu', 'decimals' => 0, 'exchange_rate' => null],
			'WST' => [ 'code' => 'WST', 'symbol' => 'WS$', 'name' => 'Samoan tala', 'decimals' => 2, 'exchange_rate' => null],
			'XAF' => [ 'code' => 'XAF', 'symbol' => 'FCFA', 'name' => 'CFA Franc BEAC', 'decimals' => 0, 'exchange_rate' => null],
			'XAG' => [ 'code' => 'XAG', 'symbol' => 'XAG', 'name' => 'Silver [one troy ounce]', 'decimals' => 0, 'exchange_rate' => null],
			'XAU' => [ 'code' => 'XAU', 'symbol' => 'XAU', 'name' => 'Gold [one troy ounce]', 'decimals' => 0, 'exchange_rate' => null],
			'XBA' => [ 'code' => 'XBA', 'symbol' => 'XBA', 'name' => 'European Composite Unit [EURCO] [bond market unit]', 'decimals' => 0, 'exchange_rate' => null],
			'XBB' => [ 'code' => 'XBB', 'symbol' => 'XBB', 'name' => 'European Monetary Unit [E.M.U.-6] [bond market unit]', 'decimals' => 0, 'exchange_rate' => null],
			'XBC' => [ 'code' => 'XBC', 'symbol' => 'XBC', 'name' => 'European Unit of Account 9 [E.U.A.-9] [bond market unit]', 'decimals' => 0, 'exchange_rate' => null],
			'XBD' => [ 'code' => 'XBD', 'symbol' => 'XBD', 'name' => 'European Unit of Account 17 [E.U.A.-17] [bond market unit]', 'decimals' => 0, 'exchange_rate' => null],
			'XCD' => [ 'code' => 'XCD', 'symbol' => '$', 'name' => 'East Caribbean Dollar', 'decimals' => 0, 'exchange_rate' => null],
			'XDR' => [ 'code' => 'XDR', 'symbol' => 'XDR', 'name' => 'Special drawing rights', 'decimals' => 0, 'exchange_rate' => null],
			'XOF' => [ 'code' => 'XOF', 'symbol' => 'CFA', 'name' => 'CFA Franc BCEAO', 'decimals' => 0, 'exchange_rate' => null],
			'XPD' => [ 'code' => 'XPD', 'symbol' => 'XPD', 'name' => 'Palladium [one troy ounce]', 'decimals' => 0, 'exchange_rate' => null],
			'XPF' => [ 'code' => 'XPF', 'symbol' => 'CFP', 'name' => 'CFP franc [franc Pacifique]', 'decimals' => 0, 'exchange_rate' => null],
			'XPT' => [ 'code' => 'XPT', 'symbol' => 'XPT', 'name' => 'Platinum [one troy ounce]', 'decimals' => 0, 'exchange_rate' => null],
			'XSU' => [ 'code' => 'XSU', 'symbol' => 'Sucre', 'name' => 'SUCRE', 'decimals' => 0, 'exchange_rate' => null],
			'XTS' => [ 'code' => 'XTS', 'symbol' => 'XTS', 'name' => 'Code reserved for testing purposes', 'decimals' => 0, 'exchange_rate' => null],
			'XUA' => [ 'code' => 'XUA', 'symbol' => 'XUA', 'name' => 'ADB Unit of Account', 'decimals' => 0, 'exchange_rate' => null],
			'XXX' => [ 'code' => 'XXX', 'symbol' => 'XXX', 'name' => 'No currency', 'decimals' => 0, 'exchange_rate' => null],
			'YER' => [ 'code' => 'YER', 'symbol' => 'YR', 'name' => 'Yemeni Rial', 'decimals' => 0, 'exchange_rate' => null],
			'ZMK' => [ 'code' => 'ZMK', 'symbol' => 'ZK', 'name' => 'Zambian Kwacha', 'decimals' => 0, 'exchange_rate' => null],
			'ZMW' => [ 'code' => 'ZMW', 'symbol' => 'ZK', 'name' => 'Zambian kwacha', 'decimals' => 2, 'exchange_rate' => null],
			'ZWD' => [ 'code' => 'ZWD', 'symbol' => 'Z$', 'name' => 'Zimbabwe Dollar', 'decimals' => 2, 'exchange_rate' => null],
			'ZWL' => [ 'code' => 'ZWL', 'symbol' => '$', 'name' => 'Zimbabwean dollar A/10', 'decimals' => 2, 'exchange_rate' => null],
			'ETH' => [ 'code' => 'ETH', 'symbol' => 'ETH', 'name' => 'Ethereum', 'decimals' => 8, 'exchange_rate' =>  null],
			'LTC' => [ 'code' => 'LTC', 'symbol' => 'LTC', 'name' => 'Litecoin', 'decimals' => 8, 'exchange_rate' =>  null],
			'USDT' => [ 'code' => 'USDT', 'symbol' => 'USDT', 'name' => 'Tether', 'decimals' => 8, 'exchange_rate' =>  null],
			'BUSD' => [ 'code' => 'BUSD', 'symbol' => 'BUSD', 'name' => 'Binance USD', 'decimals' => 8, 'exchange_rate' =>  null],
			'MBOX' => [ 'code' => 'MBOX', 'symbol' => 'MBOX', 'name' => 'Mobox', 'decimals' => 8, 'exchange_rate' =>  null],
		],
		'country_currency' => ['AF' => 'AFN','DZ' => 'DZD','AR' => 'ARS','AM' => 'AMD','AW' => 'AWG','AU' => 'AUD','CX' => 'AUD','CC' => 'AUD','HM' => 'AUD','KI' => 'AUD','NR' => 'AUD','NF' => 'AUD','TV' => 'AUD','AZ' => 'AZM','BS' => 'BSD','BH' => 'BHD','TH' => 'THB','PA' => 'USD','BB' => 'BBD','BY' => 'BYR','BZ' => 'BZD','BM' => 'BMD','VE' => 'VEB','BO' => 'BOV','BR' => 'BRL','BN' => 'BND','BG' => 'BGL','BI' => 'BIF','CA' => 'CAD','CV' => 'CVE','KY' => 'KYD','GH' => 'GHC','BJ' => 'XOF','BF' => 'XOF','CI' => 'XOF','GW' => 'GWP','ML' => 'XOF','NE' => 'XOF','SN' => 'XOF','TG' => 'XOF','CM' => 'XAF','CF' => 'XAF','TD' => 'XAF','CG' => 'XAF','GQ' => 'XAF','GA' => 'XAF','PF' => 'XPF','NC' => 'XPF','WF' => 'XPF','CL' => 'CLF','CO' => 'COP','KM' => 'KMF','BA' => 'BAM','NI' => 'NIO','CR' => 'CRC','HR' => 'HRK','CU' => 'CUP','CY' => 'CYP','CZ' => 'CZK','GM' => 'GMD','DK' => 'DKK','FO' => 'DKK','GL' => 'DKK','MK' => 'MKD','DJ' => 'DJF','ST' => 'STD','DO' => 'DOP','VN' => 'VND','DM' => 'XCD','GD' => 'XCD','MS' => 'XCD','KN' => 'XCD','LC' => 'XCD','VC' => 'XCD','AI' => 'XCD','AG' => 'XCD','EG' => 'EGP','SV' => 'USD','ET' => 'ETB','AD' => 'EUR','AT' => 'EUR','BE' => 'EUR','FI' => 'EUR','FR' => 'EUR','GF' => 'EUR','TF' => 'EUR','DE' => 'EUR','GR' => 'EUR','GP' => 'EUR','VA' => 'EUR','IE' => 'EUR','IT' => 'EUR','LU' => 'EUR','MQ' => 'EUR','YT' => 'EUR','MC' => 'EUR','NL' => 'EUR','PT' => 'EUR','RE' => 'EUR','PM' => 'EUR','SM' => 'EUR','ES' => 'EUR','FK' => 'FKP','FJ' => 'FJD','HU' => 'HUF','CD' => 'CDF','GI' => 'GIP','HT' => 'USD','PY' => 'PYG','GN' => 'GNF','GY' => 'GYD','HK' => 'HKD','UA' => 'UAH','IS' => 'ISK','BT' => 'BTN','IN' => 'INR','IR' => 'IRR','IQ' => 'IQD','JM' => 'JMD','JO' => 'JOD','KE' => 'KES','PG' => 'PGK','LA' => 'LAK','EE' => 'EEK','KW' => 'KWD','MW' => 'MWK','ZM' => 'ZMK','AO' => 'AOA','MM' => 'MMK','GE' => 'GEL','LV' => 'LVL','LB' => 'LBP','AL' => 'ALL','HN' => 'HNL','SL' => 'SLL','RO' => 'ROL','LR' => 'LRD','SZ' => 'SZL','LT' => 'LTL','LS' => 'ZAR','LY' => 'LYD','MG' => 'MGF','MY' => 'MYR','MT' => 'MTL','TM' => 'TMM','MU' => 'MUR','MZ' => 'MZM','MX' => 'MXV','MD' => 'MDL','MA' => 'MAD','EH' => 'MAD','NG' => 'NGN','ER' => 'ERN','NA' => 'ZAR','NP' => 'NPR','AN' => 'ANG','IL' => 'ILS','TW' => 'TWD','CK' => 'NZD','NZ' => 'NZD','NU' => 'NZD','PN' => 'NZD','TK' => 'NZD','AQ' => ' ','KP' => 'KPW','BV' => 'NOK','NO' => 'NOK','SJ' => 'NOK','PE' => 'PEN','MR' => 'MRO','TO' => 'TOP','PK' => 'PKR','MO' => 'MOP','UY' => 'UYU','PH' => 'PHP','GB' => 'GBP','BW' => 'BWP','QA' => 'QAR','GT' => 'GTQ','ZA' => 'ZAR','OM' => 'OMR','KH' => 'KHR','MV' => 'MVR','ID' => 'IDR','RU' => 'RUR','RW' => 'RWF','SH' => 'SHP','SA' => 'SAR','SC' => 'SCR','SG' => 'SGD','SK' => 'SKK','SB' => 'SBD','KG' => 'KGS','SO' => 'SOS','TJ' => 'TJS','LK' => 'LKR','SD' => 'SDD','SR' => 'SRD','SE' => 'SEK','LI' => 'CHF','CH' => 'CHF','SY' => 'SYP','BD' => 'BDT','WS' => 'WST','TZ' => 'TZS','KZ' => 'KZT','SI' => 'SIT','TT' => 'TTD','MN' => 'MNT','TN' => 'TND','TR' => 'TRL','AE' => 'AED','UG' => 'UGX','EC' => 'USD','AS' => 'USD','IO' => 'USD','GU' => 'USD','MH' => 'USD','FM' => 'USD','MP' => 'USD','PW' => 'USD','PR' => 'USD','TL' => 'USD','TC' => 'USD','US' => 'USS','UM' => 'USD','VG' => 'USD','VI' => 'USD','UZ' => 'UZS','VU' => 'VUV','KR' => 'KRW','YE' => 'YER','JP' => 'JPY','CN' => 'CNY','ZW' => 'ZWD','PL' => 'PLN'],
	];