<?php

return [
	"name" => "Midtrans",
	"url" => "https://midtrans.com/",
	"class" => "Midtrans",
	"slug" => "midtrans",
	"fields" => [
		"enabled" => [
			"type" => "toggler", 
			"validation" => "nullable|in:on", 
			"value" => ""			
		],
		"icon" => [
      "type" => "hidden", 
      "validation" => "nullable|string", 
      "value" => "/assets/images/payment/midtrans_icon.png",
    ],
    "description" => [
      "type" => "hidden", 
      "validation" => "nullable|string", 
      "value" => "Credit / Debit card, Danamon online, CIMB clicks, BCA klikpay, Mandiri, Alfamart, Permata va ...",
    ],
    "order" => [
			"type" => "hidden", 
			"validation" => "nullable|numeric", 
			"value" => null,
		],
		"mode" => [
			"type" => "dropdown", 
			"validation" => "nullable|string|in:live,sandbox|required_with:gateways.midtrans.enabled", 
			"value" => "sandbox", 
			"multiple" => 0,
			"options" => ["sandbox" => "Sandbox", "live" => "Live"]
		],
		"client_key" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.midtrans.enabled", 
			"value" => null
		],
		"server_key" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.midtrans.enabled", 
			"value" => null
		],
		"merchant_id" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.midtrans.enabled", 
			"value" => null
		],
		"methods" => [
			"type" => "dropdown", 
			"validation" => "nullable|string|required_with:gateways.midtrans.enabled", 
			"value" => null,
			"multiple" => 1,
			"options" => [
				"credit_card" => "Credit card",
				"danamon_online" => "Danamon online",
				"cimb_clicks" => "CIMB clicks",
				"bca_klikpay" => "BCA klikpay",
				"mandiri_clickpay" => "Mandiri clickpay",
				"bri_epay" => "BRI epay",
				"bca_klikbca" => "BCA klikbca",
				"echannel" => "Echannel",
				"mandiri_ecash" => "Mandiri ecash",
				"permata_va" => "Permata va",
				"bca_va" => "Bca va",
				"bni_va" => "Bni va",
				"other_va" => "Other va",
				"indomaret" => "Indomaret",
				"alfamart" => "Alfamart",
				"akulaku" => "Akulaku"
			]
		],
		"fee" => [
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"minimum" => [  // The minimum amount to pay to "Pay what you want"
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"auto_exchange_to" => [ // Auto-exchange Currency to This currency when using multiple currencies
			"type" => "string", 
			"validation" => "nullable|string|max:3", 
			"value" => null
		]
	],
	"methods_icons" => [
		"mastercard-curved-64px.png" => null,
		"visa-curved-64px.png" => null,
		"american-express-curved-64px.png" => null,
		"discover-curved-64px.png" => null,
	],
	"form" => [
    "inputs" => [
      "cart" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "subscription_id" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "prepaid_credits_pack_id" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "processor" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "coupon" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "locale" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "_token" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
      "checkout_token" => ["type" => "hidden", "label" => null, "value" => "", "class" => "d-none", "replace" => []],
    ],
    "note" => [],
    "checkout_buttons" => []
  ],
	"assets" => [],
	"guest_checkout" => 1,
	"async" => 0,
	"supports_recurrent" => 0,
	"webhook_responses" => ["success" => "200 OK", "failed" => "404 Not Found"],
	"payment_link" => 1,
];
